//Beaglebone general purpose GPIO manipulation functions
//Designed by : ABHISHEK KUMAR (140250330004)

//#################################################################################################### HELPING FUNCTIONS : GPIO 
int file_exist(char *filename)//check if file/folder exists or not,RETURNS 0=NOT EXISTS, 1=EXISTS
{
	struct stat buffer;
	return(!stat(filename,&buffer));
}

int8_t gpio_init(uint8_t x,uint8_t y)//returns = 0-Success,(-1)-Fail 
{
	int16_t fd,res;
	uint8_t v[5],str[50];

	//first check if file already exists or not
	sprintf(str,"/sys/class/gpio/gpio%u",(x*32+y));
	if(file_exist(str))//if file already exists,no need to export it
	{
		printf("Pin already initiated!!\n");
		return 0;//depict success
	}

	sprintf(v,"%u",(x*32+y));//convert number to string format
	//printf("Value to be written = %s\n",v);

	fd = open("/sys/class/gpio/export",O_WRONLY);
	if(fd<0)
	{
		perror("XXXX : Failed initiating the pin - ");
		return -1;
	}
	
	res = write(fd,v,strlen(v));
	if(res!=strlen(v))
	{
		close(fd);
		perror("XXXX : Failed initiating the pin - ");
		return -1;
	}

	close(fd);
	printf("Pin %u : initiated successfully!!\n",atoi(v));
	return 0;
}

int8_t gpio_de_init(uint8_t x,uint8_t y)//returns = 0-Success,(-1)-Fail 
{
	int16_t fd,res;
	uint8_t v[5],str[50];

	//first check if file already exists or not
	sprintf(str,"/sys/class/gpio/gpio%u",(x*32+y));
	if(!file_exist(str))//if file does not exists,no need to unexport it
	{
		printf("Pin already deinitiated!!\n");
		return 0;//depict success
	}

	sprintf(v,"%u",(x*32+y));//convert number to string format
	//printf("Value to be written = %s\n",v);

	fd = open("/sys/class/gpio/unexport",O_WRONLY);
	if(fd<0)
	{
		perror("XXXX : Failed de_initiating the pin - ");
		return -1;
	}
	
	res = write(fd,v,strlen(v));
	if(res!=strlen(v))
	{
		close(fd);
		perror("XXXX : Failed de_initiating the pin - ");
		return -1;
	}

	close(fd);
	printf("Pin %u : de_initiated successfully!!\n",atoi(v));
	return 0;
}

int8_t gpio_dir(uint8_t x,uint8_t y,uint8_t dir)//dir = 0-Output,1-Input  , returns = 0-Success,(-1)-Fail 
{
	if(dir!=1 && dir!=0)
	{
		perror("XXXX : Wrong data provision for pin - ");
		return -1;
	}

	int16_t fd,res;
	uint8_t str[50];
	sprintf(str,"/sys/class/gpio/gpio%u/direction",(x*32+y));//build the string to be written
	
	fd = open(str,O_WRONLY);
	if(fd<0)
	{
		perror("XXXX : Failed initiating direction of the pin - ");
		return -1;
	}
	
	if(1==dir)//1=Input
	{
		res = write(fd,"in",2);
		if(res!=2)
		{
			close(fd);
			perror("XXXX : Failed initiating direction of the pin - ");
			return -1;
		}
	}
	else if(0==dir)//0=Output
	{
		res = write(fd,"out",3);
		if(res!=3)
		{
			close(fd);
			perror("XXXX : Failed initiating direction of the pin - ");
			return -1;
		}
	}
		
	close(fd);
	printf("Pin %u : direction = %s,initiated successfully!!\n",(x*32+y),( dir==1?"IN":"OUT" ));
	return 0;
}

int8_t gpio_write(uint8_t x,uint8_t y,uint8_t val)//val = 0-Logic 0,1-Logic 1 , returns = 0-Success,(-1)-Fail 
{
	if(val!=1 && val!=0)
	{
		perror("XXXX : Wrong data provision for pin - ");
		return -1;
	}

	int16_t fd,res;
	uint8_t str[50];
	sprintf(str,"/sys/class/gpio/gpio%u/value",(x*32+y));//build the string to be written
	
	fd = open(str,O_WRONLY);
	if(fd<0)
	{
		perror("XXXX : Failed initiating value at the pin - ");
		return -1;
	}
	
	if(1==val)//1=High
	{
		res = write(fd,"1",1);
		if(res!=1)
		{
			close(fd);
			perror("XXXX : Failed initiating value at the pin - ");
			return -1;
		}
	}
	else if(0==val)//0=Low
	{
		res = write(fd,"0",1);
		if(res!=1)
		{
			close(fd);
			perror("XXXX : Failed initiating value at the pin - ");
			return -1;
		}
	}

	close(fd);
	//printf("Pin %u : value = %s,initiated successfully!!\n",(x*32+y),( val==1?"1":"0" ));
	return 0;
}

int8_t gpio_read(uint8_t x,uint8_t y)//returns = 0-Logic 0,1-Logic 1,(-1)-Fail reading 
{
	int16_t fd,res;
	uint8_t str[50],val[5];
	sprintf(str,"/sys/class/gpio/gpio%u/value",(x*32+y));//build the string to be written
	
	fd = open(str,O_RDONLY);
	if(fd<0)
	{
		perror("XXXX : Failed reading pin - ");
		return -1;
	}
	
	res = read(fd,val,1);//read the pin
	if(res!=1)
	{
		close(fd);
		perror("XXXX : Failed reading pin - ");
		return -1;
	}

	close(fd);
	//printf("Pin %u : value = %u,read successfully!!\n",(x*32+y),atoi(val));
	return atoi(val);
}

